﻿namespace Code6587EN.Ch07.Controls
{
    using Microsoft.SharePoint.Utilities;
    using Microsoft.SharePoint.WebControls;
    using System.Web.UI;

    /// <summary>
    /// ASP.NET user control to restore the navigate up breadcrumb control on the page.
    /// </summary>
    public class RestoreBreadcrumb : UserControl
    {
        // Override the CreateChildControls method to modify the properties of the breadcrumb control
        // and make it display
        protected override void CreateChildControls()
        {
            // Wrap the code in an SPMonitoredScope
            // http://msdn.microsoft.com/en-us/library/ff512758(v=office.14).aspx
            using (new SPMonitoredScope("Code6587EN.Ch07.Controls.RestoreBreadcrumb::CreateChildControls"))
            {
                // Get the current Master Page
                var masterPage = this.Page.Master;

                // Find the breadcrumb container on the page
                var delta = masterPage.FindControl("DeltaBreadcrumbDropdown") as AjaxDelta;
                if (delta != null)
                {
                    // Find the breadcrumb control on the page
                    var breadcrumb = delta.FindControl("GlobalBreadCrumbNavPopout") as PopoutMenu;
                    if (breadcrumb != null)
                    {
                        // Set the breadcrumb to be visible and apply the correct image for the control
                        // Note: this enables it to support themed sites, otherwise it will just remain the grey image no matter what theme is applied
                        breadcrumb.Visible = true;
                        breadcrumb.ThemeKey = "spcommon";
                        breadcrumb.IconUrl = "/_layouts/15/images/spcommon.png";

                        // Add CSS to the page to force the parent element to display
                        this.Controls.Add(new LiteralControl("<style type=\"text/css\">.ms-breadcrumb-dropdownBox { display: inline-block !important; }</style>"));
                    }
                }
            }
        }
    }
}
